/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class DateTimeBean
extends PanelBean
implements DataBean {
    private static final String CLASS_NAME = "[DateTimeBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String CANCEL = "CANCEL";
    private static final String DATE_TIME_PANEL = "DateTimePanel";
    private static final String DEFAULT_WINDOW = "TenMinItem";
    private static final String FIFTY_MIN_ITEM = "FiftyMinItem";
    private static final String FORTY_MIN_ITEM = "FortyMinItem";
    private static final String OK_BUTTON = "OKButton";
    private static final String SIXTY_MIN_ITEM = "SixtyMinItem";
    private static final String TEN_MIN_ITEM = "TenMinItem";
    private static final String THIRTY_MIN_ITEM = "ThirtyMinItem";
    private static final String TWENTY_MIN_ITEM = "TwentyMinItem";
    private static final String WINDOW_CHOICE = "TimeWindowChoice";
    private String m_sSelectListOutput;
    private Calendar m_cDateNumber;
    private Calendar m_cTimeNumber;
    private String[] m_sTimeWindowChoiceSelection;
    private ArrayList objectNames;

    public DateTimeBean(String name, ArrayList objectNames) {
        this.setBeanName(name);
        this.objectNames = objectNames;
    }

    public void prepare() {
        ClientUserContext userContext;
        Trace.trace(TRACE_MASKT, "[DateTimeBean] >> prepare()");
        this.getUserTaskManager().setSelected(this.getMountPrefix() + "TenMinItem", true);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.objectNames.iterator();
        while (iterator.hasNext()) {
            buffer.append(((LocalizableText)iterator.next()).toString());
            buffer.append("  ");
        }
        this.setSelectListOutput(buffer.toString());
        try {
            userContext = ClientUserContext.getUserContext();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception caught!");
            Trace.trace(TRACE_MASKF, e);
            throw new RuntimeException(e);
        }
        Calendar date = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        Calendar time = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        this.setDateNumber(date);
        this.setTimeNumber(time);
        this.setTimeWindowChoiceSelection(new String[]{this.getMountPrefix() + "TenMinItem"});
        Trace.trace(TRACE_MASKT, "[DateTimeBean] << prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "[DateTimeBean] >> panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        Trace.trace(TRACE_MASKT, "<< panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "[DateTimeBean] >> parentalAction() : \n   Bean Name     : " + this.getBeanName() + "\n   CurrentElement: " + event.getCurrentElement() + "\n   ElementName   : " + event.getElementName() + "\n   ActionCommand : " + event.getActionCommand());
        Date date = this.getDateNumber().getTime();
        Date time = this.getTimeNumber().getTime();
        String[] string = this.getTimeWindowChoiceSelection();
        Long window = null;
        if (string[0].endsWith("TenMinItem")) {
            window = new Long(600000L);
        } else if (string[0].endsWith(TWENTY_MIN_ITEM)) {
            window = new Long(1200000L);
        } else if (string[0].endsWith(THIRTY_MIN_ITEM)) {
            window = new Long(1800000L);
        } else if (string[0].endsWith(FORTY_MIN_ITEM)) {
            window = new Long(2400000L);
        } else if (string[0].endsWith(FIFTY_MIN_ITEM)) {
            window = new Long(3000000L);
        } else if (string[0].endsWith(SIXTY_MIN_ITEM)) {
            window = new Long(3600000L);
        }
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        map.put("DATE", date);
        map.put("TIME", time);
        map.put("WINDOW", window);
        this.sendTaskletRequest("PANEL_DATA", map);
        Trace.trace(TRACE_MASKT, "[DateTimeBean] << parentalAction()");
    }

    private void sendTaskletRequest(String actionCommand, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + actionCommand);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", actionCommand);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    public String getSelectListOutput() {
        return this.m_sSelectListOutput;
    }

    public void setSelectListOutput(String s) throws IllegalUserDataException {
        this.m_sSelectListOutput = s;
    }

    public Calendar getDateNumber() {
        return this.m_cDateNumber;
    }

    public void setDateNumber(Calendar c) throws IllegalUserDataException {
        if (c == null) {
            Trace.trace(TRACE_MASKT, "[DateTimeBean]    Ignoring null date ... ");
            throw new IllegalUserDataException("A invalid null date was specified. \nPlease enter a valid date.");
        }
        this.m_cDateNumber = c;
    }

    public Calendar getTimeNumber() {
        return this.m_cTimeNumber;
    }

    public void setTimeNumber(Calendar c) throws IllegalUserDataException {
        if (c == null) {
            Trace.trace(TRACE_MASKT, "[DateTimeBean]    Ignoring null time ... ");
            throw new IllegalUserDataException("An invalid null time was specified. \nPlease enter a valid time.");
        }
        this.m_cTimeNumber = c;
    }

    public String[] getTimeWindowChoiceSelection() {
        return this.m_sTimeWindowChoiceSelection;
    }

    public void setTimeWindowChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sTimeWindowChoiceSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "[DateTimeBean] <> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "[DateTimeBean] <> save()");
    }

    public void load() {
    }
}

